/**
 * 
 */
package gov.va.med.mhv.bluebutton.converter;

import gov.va.med.mhv.bluebutton.model.PhrRadiology;
import gov.va.med.mhv.bluebutton.transfer.StudyDTO;

import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

@Component
public class PhrRadiologyStudyConverter implements Converter<PhrRadiology, StudyDTO> {

	@Override
	public StudyDTO convert(PhrRadiology s) {
		StudyDTO d = new StudyDTO();
		
		d.setId(s.getId());
		d.setStationNumber(s.getStationNumber());
		d.setPatientId(s.getPatientId());
		d.setProcedureName(s.getProcedureName());
		d.setPerformedDatePrecise(s.getEventDate().getDatePrecise());
		
		FacilityInfoConverter c = new FacilityInfoConverter();
		d.setFacilityInfo(c.convert(s.getFacilityInfo()));

		return d;
	}
	
}
